/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class})
public class MixinFreezingWater {
    private static LevelReader LEVEL = null;
    private static Boolean IS_CHECKING_FREEZING = false;

    @Inject(method={"shouldFreeze(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldFreezeBlock(LevelReader levelReader, BlockPos pos, boolean mustBeAtEdge, CallbackInfoReturnable<Boolean> cir) {
        if (!ConfigSettings.USE_CUSTOM_WATER_FREEZE_BEHAVIOR.get().booleanValue()) {
            return;
        }
        LEVEL = levelReader;
        IS_CHECKING_FREEZING = true;
        if (!ConfigSettings.COLD_SOUL_FIRE.get().booleanValue()) {
            return;
        }
        BlockState blockstate = levelReader.m_8055_(pos);
        FluidState fluidstate = levelReader.m_6425_(pos);
        if (fluidstate.m_76152_() != Fluids.f_76193_ || !(blockstate.m_60734_() instanceof LiquidBlock)) {
            return;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    mutable.m_122190_((Vec3i)pos).m_122184_(x, y, z);
                    BlockState state = levelReader.m_8055_((BlockPos)mutable);
                    if (!ConfigSettings.COLD_SOUL_FIRE.get().booleanValue() || !state.m_60713_(Blocks.f_50084_) && (!state.m_60713_(Blocks.f_50684_) || !((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue())) continue;
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }

    @Inject(method={"getTemperature"}, at={@At(value="HEAD")}, cancellable=true)
    private void getTemperature(BlockPos pos, CallbackInfoReturnable<Float> cir) {
        LevelReader levelReader;
        if (!ConfigSettings.USE_CUSTOM_WATER_FREEZE_BEHAVIOR.get().booleanValue()) {
            return;
        }
        if (IS_CHECKING_FREEZING.booleanValue() && (levelReader = LEVEL) instanceof Level) {
            Level level = (Level)levelReader;
            double biomeTemp = WorldHelper.getWorldTemperatureAt(level, pos);
            cir.setReturnValue((Object)Float.valueOf((float)biomeTemp));
        }
        IS_CHECKING_FREEZING = false;
    }
}

